/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package chapter9.timezones;

import java.time.*;
import static java.time.Month.*;
import java.time.format.TextStyle;
import static java.time.temporal.ChronoUnit.HOURS;
import java.time.zone.ZoneRulesProvider;
import java.util.Locale;

/** 
 * @author Matthew Gregory
 */
public class StartHere {
    
    public static void main(String[] args) {
        DataSource myData = new DataSource();
        
        //Create the meeting
        Meeting myMeeting = new Meeting(myData.people[0],LocalDateTime.now().plusDays(7).truncatedTo(HOURS));
        //make a list of attendees
        Person[] attendees = {myData.people[1],myData.people[2]};
        //assign the people to the meeting
        myMeeting.attendees = attendees;
        //Print out the results
//        myMeeting.displayMeetingDetails();
                
//        System.out.println("Meeting Date: "+myMeeting.meetingDate);
        
        //What is the current time zone and offset of this date?
//        System.out.println("Local Meeting Date "+myMeeting.meetingDate.toLocalDateTime()
//                +" - time zone: "+myMeeting.meetingDate.getZone()
//                +" - offset: "+myMeeting.meetingDate.getOffset());
//        //How is this affected if I add 6 months?
//        ZonedDateTime reviewMeetingDate= myMeeting.meetingDate.plusMonths(6); 
//        System.out.println("Local Review Meeting Date "+reviewMeetingDate.toLocalDateTime()
//                +" - time zone: "+reviewMeetingDate.getZone()
//                +" - offset: "+reviewMeetingDate.getOffset());
        
        //To see what time zones are available
//        for (String zone : ZoneRulesProvider.getAvailableZoneIds()){
//            System.out.println("Zone: "+zone);
//        }
        myMeeting.displayMeetingDate();
    }
}
    
